/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.InventoryCount;
import java.util.List;
import java.util.Objects;

public class RetrieveInventoryCountResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<InventoryCount> counts;
    private final String cursor;

    @JsonCreator
    public RetrieveInventoryCountResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="counts") List<InventoryCount> counts, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.counts = counts;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="counts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<InventoryCount> getCounts() {
        return this.counts;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.counts, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveInventoryCountResponse)) {
            return false;
        }
        RetrieveInventoryCountResponse other = (RetrieveInventoryCountResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.counts, other.counts) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "RetrieveInventoryCountResponse [errors=" + this.errors + ", counts=" + this.counts + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).counts(this.getCounts()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<InventoryCount> counts;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder counts(List<InventoryCount> counts) {
            this.counts = counts;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public RetrieveInventoryCountResponse build() {
            RetrieveInventoryCountResponse model = new RetrieveInventoryCountResponse(this.errors, this.counts, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

