/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.InventoryPhysicalCount;
import java.util.List;
import java.util.Objects;

public class RetrieveInventoryPhysicalCountResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final InventoryPhysicalCount count;

    @JsonCreator
    public RetrieveInventoryPhysicalCountResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="count") InventoryPhysicalCount count) {
        this.errors = errors;
        this.count = count;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="count")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public InventoryPhysicalCount getCount() {
        return this.count;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.count);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveInventoryPhysicalCountResponse)) {
            return false;
        }
        RetrieveInventoryPhysicalCountResponse other = (RetrieveInventoryPhysicalCountResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.count, other.count);
    }

    public String toString() {
        return "RetrieveInventoryPhysicalCountResponse [errors=" + this.errors + ", count=" + this.count + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).count(this.getCount());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private InventoryPhysicalCount count;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder count(InventoryPhysicalCount count) {
            this.count = count;
            return this;
        }

        public RetrieveInventoryPhysicalCountResponse build() {
            RetrieveInventoryPhysicalCountResponse model = new RetrieveInventoryPhysicalCountResponse(this.errors, this.count);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

