/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Location;
import java.util.List;
import java.util.Objects;

public class RetrieveLocationResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final Location location;

    @JsonCreator
    public RetrieveLocationResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="location") Location location) {
        this.errors = errors;
        this.location = location;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="location")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Location getLocation() {
        return this.location;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.location);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveLocationResponse)) {
            return false;
        }
        RetrieveLocationResponse other = (RetrieveLocationResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.location, other.location);
    }

    public String toString() {
        return "RetrieveLocationResponse [errors=" + this.errors + ", location=" + this.location + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).location(this.getLocation());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private Location location;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder location(Location location) {
            this.location = location;
            return this;
        }

        public RetrieveLocationResponse build() {
            RetrieveLocationResponse model = new RetrieveLocationResponse(this.errors, this.location);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

