/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Vendor;
import java.util.List;
import java.util.Objects;

public class RetrieveVendorResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final Vendor vendor;

    @JsonCreator
    public RetrieveVendorResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="vendor") Vendor vendor) {
        this.errors = errors;
        this.vendor = vendor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="vendor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Vendor getVendor() {
        return this.vendor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.vendor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveVendorResponse)) {
            return false;
        }
        RetrieveVendorResponse other = (RetrieveVendorResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.vendor, other.vendor);
    }

    public String toString() {
        return "RetrieveVendorResponse [errors=" + this.errors + ", vendor=" + this.vendor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).vendor(this.getVendor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private Vendor vendor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder vendor(Vendor vendor) {
            this.vendor = vendor;
            return this;
        }

        public RetrieveVendorResponse build() {
            RetrieveVendorResponse model = new RetrieveVendorResponse(this.errors, this.vendor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

