/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class RevokeTokenRequest {
    private final String clientId;
    private final String accessToken;
    private final String merchantId;
    private final Boolean revokeOnlyAccessToken;

    @JsonCreator
    public RevokeTokenRequest(@JsonProperty(value="client_id") String clientId, @JsonProperty(value="access_token") String accessToken, @JsonProperty(value="merchant_id") String merchantId, @JsonProperty(value="revoke_only_access_token") Boolean revokeOnlyAccessToken) {
        this.clientId = clientId;
        this.accessToken = accessToken;
        this.merchantId = merchantId;
        this.revokeOnlyAccessToken = revokeOnlyAccessToken;
    }

    @JsonGetter(value="client_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientId() {
        return this.clientId;
    }

    @JsonGetter(value="access_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonGetter(value="merchant_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonGetter(value="revoke_only_access_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getRevokeOnlyAccessToken() {
        return this.revokeOnlyAccessToken;
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.accessToken, this.merchantId, this.revokeOnlyAccessToken);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RevokeTokenRequest)) {
            return false;
        }
        RevokeTokenRequest other = (RevokeTokenRequest)obj;
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.accessToken, other.accessToken) && Objects.equals(this.merchantId, other.merchantId) && Objects.equals(this.revokeOnlyAccessToken, other.revokeOnlyAccessToken);
    }

    public String toString() {
        return "RevokeTokenRequest [clientId=" + this.clientId + ", accessToken=" + this.accessToken + ", merchantId=" + this.merchantId + ", revokeOnlyAccessToken=" + this.revokeOnlyAccessToken + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().clientId(this.getClientId()).accessToken(this.getAccessToken()).merchantId(this.getMerchantId()).revokeOnlyAccessToken(this.getRevokeOnlyAccessToken());
        return builder;
    }

    public static class Builder {
        private String clientId;
        private String accessToken;
        private String merchantId;
        private Boolean revokeOnlyAccessToken;

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder revokeOnlyAccessToken(Boolean revokeOnlyAccessToken) {
            this.revokeOnlyAccessToken = revokeOnlyAccessToken;
            return this;
        }

        public RevokeTokenRequest build() {
            return new RevokeTokenRequest(this.clientId, this.accessToken, this.merchantId, this.revokeOnlyAccessToken);
        }
    }
}

