/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class SaveCardOptions {
    private final String customerId;
    private final String cardId;
    private final String referenceId;

    @JsonCreator
    public SaveCardOptions(@JsonProperty(value="customer_id") String customerId, @JsonProperty(value="card_id") String cardId, @JsonProperty(value="reference_id") String referenceId) {
        this.customerId = customerId;
        this.cardId = cardId;
        this.referenceId = referenceId;
    }

    @JsonGetter(value="customer_id")
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonGetter(value="card_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCardId() {
        return this.cardId;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.cardId, this.referenceId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SaveCardOptions)) {
            return false;
        }
        SaveCardOptions other = (SaveCardOptions)obj;
        return Objects.equals(this.customerId, other.customerId) && Objects.equals(this.cardId, other.cardId) && Objects.equals(this.referenceId, other.referenceId);
    }

    public String toString() {
        return "SaveCardOptions [customerId=" + this.customerId + ", cardId=" + this.cardId + ", referenceId=" + this.referenceId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.customerId).cardId(this.getCardId()).referenceId(this.getReferenceId());
        return builder;
    }

    public static class Builder {
        private String customerId;
        private String cardId;
        private String referenceId;

        public Builder(String customerId) {
            this.customerId = customerId;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder cardId(String cardId) {
            this.cardId = cardId;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public SaveCardOptions build() {
            return new SaveCardOptions(this.customerId, this.cardId, this.referenceId);
        }
    }
}

