/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.SegmentFilter;
import com.squareup.square.models.TimeRange;
import java.util.List;
import java.util.Objects;

public class SearchAvailabilityFilter {
    private final TimeRange startAtRange;
    private final String locationId;
    private final List<SegmentFilter> segmentFilters;
    private final String bookingId;

    @JsonCreator
    public SearchAvailabilityFilter(@JsonProperty(value="start_at_range") TimeRange startAtRange, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="segment_filters") List<SegmentFilter> segmentFilters, @JsonProperty(value="booking_id") String bookingId) {
        this.startAtRange = startAtRange;
        this.locationId = locationId;
        this.segmentFilters = segmentFilters;
        this.bookingId = bookingId;
    }

    @JsonGetter(value="start_at_range")
    public TimeRange getStartAtRange() {
        return this.startAtRange;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="segment_filters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<SegmentFilter> getSegmentFilters() {
        return this.segmentFilters;
    }

    @JsonGetter(value="booking_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBookingId() {
        return this.bookingId;
    }

    public int hashCode() {
        return Objects.hash(this.startAtRange, this.locationId, this.segmentFilters, this.bookingId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchAvailabilityFilter)) {
            return false;
        }
        SearchAvailabilityFilter other = (SearchAvailabilityFilter)obj;
        return Objects.equals(this.startAtRange, other.startAtRange) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.segmentFilters, other.segmentFilters) && Objects.equals(this.bookingId, other.bookingId);
    }

    public String toString() {
        return "SearchAvailabilityFilter [startAtRange=" + this.startAtRange + ", locationId=" + this.locationId + ", segmentFilters=" + this.segmentFilters + ", bookingId=" + this.bookingId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.startAtRange).locationId(this.getLocationId()).segmentFilters(this.getSegmentFilters()).bookingId(this.getBookingId());
        return builder;
    }

    public static class Builder {
        private TimeRange startAtRange;
        private String locationId;
        private List<SegmentFilter> segmentFilters;
        private String bookingId;

        public Builder(TimeRange startAtRange) {
            this.startAtRange = startAtRange;
        }

        public Builder startAtRange(TimeRange startAtRange) {
            this.startAtRange = startAtRange;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder segmentFilters(List<SegmentFilter> segmentFilters) {
            this.segmentFilters = segmentFilters;
            return this;
        }

        public Builder bookingId(String bookingId) {
            this.bookingId = bookingId;
            return this;
        }

        public SearchAvailabilityFilter build() {
            return new SearchAvailabilityFilter(this.startAtRange, this.locationId, this.segmentFilters, this.bookingId);
        }
    }
}

