/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Availability;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class SearchAvailabilityResponse {
    private HttpContext httpContext;
    private final List<Availability> availabilities;
    private final List<Error> errors;

    @JsonCreator
    public SearchAvailabilityResponse(@JsonProperty(value="availabilities") List<Availability> availabilities, @JsonProperty(value="errors") List<Error> errors) {
        this.availabilities = availabilities;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="availabilities")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Availability> getAvailabilities() {
        return this.availabilities;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.availabilities, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchAvailabilityResponse)) {
            return false;
        }
        SearchAvailabilityResponse other = (SearchAvailabilityResponse)obj;
        return Objects.equals(this.availabilities, other.availabilities) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "SearchAvailabilityResponse [availabilities=" + this.availabilities + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().availabilities(this.getAvailabilities()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Availability> availabilities;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder availabilities(List<Availability> availabilities) {
            this.availabilities = availabilities;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public SearchAvailabilityResponse build() {
            SearchAvailabilityResponse model = new SearchAvailabilityResponse(this.availabilities, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

