/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CustomerQuery;
import java.util.Objects;

public class SearchCustomersRequest {
    private final String cursor;
    private final Long limit;
    private final CustomerQuery query;

    @JsonCreator
    public SearchCustomersRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="limit") Long limit, @JsonProperty(value="query") CustomerQuery query) {
        this.cursor = cursor;
        this.limit = limit;
        this.query = query;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getLimit() {
        return this.limit;
    }

    @JsonGetter(value="query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerQuery getQuery() {
        return this.query;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.limit, this.query);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchCustomersRequest)) {
            return false;
        }
        SearchCustomersRequest other = (SearchCustomersRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.limit, other.limit) && Objects.equals(this.query, other.query);
    }

    public String toString() {
        return "SearchCustomersRequest [cursor=" + this.cursor + ", limit=" + this.limit + ", query=" + this.query + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().cursor(this.getCursor()).limit(this.getLimit()).query(this.getQuery());
        return builder;
    }

    public static class Builder {
        private String cursor;
        private Long limit;
        private CustomerQuery query;

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder query(CustomerQuery query) {
            this.query = query;
            return this;
        }

        public SearchCustomersRequest build() {
            return new SearchCustomersRequest(this.cursor, this.limit, this.query);
        }
    }
}

