/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Invoice;
import java.util.List;
import java.util.Objects;

public class SearchInvoicesResponse {
    private HttpContext httpContext;
    private final List<Invoice> invoices;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public SearchInvoicesResponse(@JsonProperty(value="invoices") List<Invoice> invoices, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.invoices = invoices;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="invoices")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Invoice> getInvoices() {
        return this.invoices;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.invoices, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchInvoicesResponse)) {
            return false;
        }
        SearchInvoicesResponse other = (SearchInvoicesResponse)obj;
        return Objects.equals(this.invoices, other.invoices) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "SearchInvoicesResponse [invoices=" + this.invoices + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().invoices(this.getInvoices()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Invoice> invoices;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder invoices(List<Invoice> invoices) {
            this.invoices = invoices;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public SearchInvoicesResponse build() {
            SearchInvoicesResponse model = new SearchInvoicesResponse(this.invoices, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

