/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.LoyaltyAccountMapping;
import java.util.List;
import java.util.Objects;

public class SearchLoyaltyAccountsRequestLoyaltyAccountQuery {
    private final List<LoyaltyAccountMapping> mappings;
    private final List<String> customerIds;

    @JsonCreator
    public SearchLoyaltyAccountsRequestLoyaltyAccountQuery(@JsonProperty(value="mappings") List<LoyaltyAccountMapping> mappings, @JsonProperty(value="customer_ids") List<String> customerIds) {
        this.mappings = mappings;
        this.customerIds = customerIds;
    }

    @JsonGetter(value="mappings")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<LoyaltyAccountMapping> getMappings() {
        return this.mappings;
    }

    @JsonGetter(value="customer_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getCustomerIds() {
        return this.customerIds;
    }

    public int hashCode() {
        return Objects.hash(this.mappings, this.customerIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchLoyaltyAccountsRequestLoyaltyAccountQuery)) {
            return false;
        }
        SearchLoyaltyAccountsRequestLoyaltyAccountQuery other = (SearchLoyaltyAccountsRequestLoyaltyAccountQuery)obj;
        return Objects.equals(this.mappings, other.mappings) && Objects.equals(this.customerIds, other.customerIds);
    }

    public String toString() {
        return "SearchLoyaltyAccountsRequestLoyaltyAccountQuery [mappings=" + this.mappings + ", customerIds=" + this.customerIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().mappings(this.getMappings()).customerIds(this.getCustomerIds());
        return builder;
    }

    public static class Builder {
        private List<LoyaltyAccountMapping> mappings;
        private List<String> customerIds;

        public Builder mappings(List<LoyaltyAccountMapping> mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder customerIds(List<String> customerIds) {
            this.customerIds = customerIds;
            return this;
        }

        public SearchLoyaltyAccountsRequestLoyaltyAccountQuery build() {
            return new SearchLoyaltyAccountsRequestLoyaltyAccountQuery(this.mappings, this.customerIds);
        }
    }
}

