/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.LoyaltyAccount;
import java.util.List;
import java.util.Objects;

public class SearchLoyaltyAccountsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<LoyaltyAccount> loyaltyAccounts;
    private final String cursor;

    @JsonCreator
    public SearchLoyaltyAccountsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="loyalty_accounts") List<LoyaltyAccount> loyaltyAccounts, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.loyaltyAccounts = loyaltyAccounts;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="loyalty_accounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<LoyaltyAccount> getLoyaltyAccounts() {
        return this.loyaltyAccounts;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.loyaltyAccounts, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchLoyaltyAccountsResponse)) {
            return false;
        }
        SearchLoyaltyAccountsResponse other = (SearchLoyaltyAccountsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.loyaltyAccounts, other.loyaltyAccounts) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "SearchLoyaltyAccountsResponse [errors=" + this.errors + ", loyaltyAccounts=" + this.loyaltyAccounts + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).loyaltyAccounts(this.getLoyaltyAccounts()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<LoyaltyAccount> loyaltyAccounts;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder loyaltyAccounts(List<LoyaltyAccount> loyaltyAccounts) {
            this.loyaltyAccounts = loyaltyAccounts;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public SearchLoyaltyAccountsResponse build() {
            SearchLoyaltyAccountsResponse model = new SearchLoyaltyAccountsResponse(this.errors, this.loyaltyAccounts, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

