/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.LoyaltyEvent;
import java.util.List;
import java.util.Objects;

public class SearchLoyaltyEventsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<LoyaltyEvent> events;
    private final String cursor;

    @JsonCreator
    public SearchLoyaltyEventsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="events") List<LoyaltyEvent> events, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.events = events;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="events")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<LoyaltyEvent> getEvents() {
        return this.events;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.events, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchLoyaltyEventsResponse)) {
            return false;
        }
        SearchLoyaltyEventsResponse other = (SearchLoyaltyEventsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.events, other.events) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "SearchLoyaltyEventsResponse [errors=" + this.errors + ", events=" + this.events + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).events(this.getEvents()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<LoyaltyEvent> events;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder events(List<LoyaltyEvent> events) {
            this.events = events;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public SearchLoyaltyEventsResponse build() {
            SearchLoyaltyEventsResponse model = new SearchLoyaltyEventsResponse(this.errors, this.events, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

