/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.LoyaltyReward;
import java.util.List;
import java.util.Objects;

public class SearchLoyaltyRewardsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<LoyaltyReward> rewards;
    private final String cursor;

    @JsonCreator
    public SearchLoyaltyRewardsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="rewards") List<LoyaltyReward> rewards, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.rewards = rewards;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="rewards")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<LoyaltyReward> getRewards() {
        return this.rewards;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.rewards, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchLoyaltyRewardsResponse)) {
            return false;
        }
        SearchLoyaltyRewardsResponse other = (SearchLoyaltyRewardsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.rewards, other.rewards) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "SearchLoyaltyRewardsResponse [errors=" + this.errors + ", rewards=" + this.rewards + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).rewards(this.getRewards()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<LoyaltyReward> rewards;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder rewards(List<LoyaltyReward> rewards) {
            this.rewards = rewards;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public SearchLoyaltyRewardsResponse build() {
            SearchLoyaltyRewardsResponse model = new SearchLoyaltyRewardsResponse(this.errors, this.rewards, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

