/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.SearchOrdersCustomerFilter;
import com.squareup.square.models.SearchOrdersDateTimeFilter;
import com.squareup.square.models.SearchOrdersFulfillmentFilter;
import com.squareup.square.models.SearchOrdersSourceFilter;
import com.squareup.square.models.SearchOrdersStateFilter;
import java.util.Objects;

public class SearchOrdersFilter {
    private final SearchOrdersStateFilter stateFilter;
    private final SearchOrdersDateTimeFilter dateTimeFilter;
    private final SearchOrdersFulfillmentFilter fulfillmentFilter;
    private final SearchOrdersSourceFilter sourceFilter;
    private final SearchOrdersCustomerFilter customerFilter;

    @JsonCreator
    public SearchOrdersFilter(@JsonProperty(value="state_filter") SearchOrdersStateFilter stateFilter, @JsonProperty(value="date_time_filter") SearchOrdersDateTimeFilter dateTimeFilter, @JsonProperty(value="fulfillment_filter") SearchOrdersFulfillmentFilter fulfillmentFilter, @JsonProperty(value="source_filter") SearchOrdersSourceFilter sourceFilter, @JsonProperty(value="customer_filter") SearchOrdersCustomerFilter customerFilter) {
        this.stateFilter = stateFilter;
        this.dateTimeFilter = dateTimeFilter;
        this.fulfillmentFilter = fulfillmentFilter;
        this.sourceFilter = sourceFilter;
        this.customerFilter = customerFilter;
    }

    @JsonGetter(value="state_filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SearchOrdersStateFilter getStateFilter() {
        return this.stateFilter;
    }

    @JsonGetter(value="date_time_filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SearchOrdersDateTimeFilter getDateTimeFilter() {
        return this.dateTimeFilter;
    }

    @JsonGetter(value="fulfillment_filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SearchOrdersFulfillmentFilter getFulfillmentFilter() {
        return this.fulfillmentFilter;
    }

    @JsonGetter(value="source_filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SearchOrdersSourceFilter getSourceFilter() {
        return this.sourceFilter;
    }

    @JsonGetter(value="customer_filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SearchOrdersCustomerFilter getCustomerFilter() {
        return this.customerFilter;
    }

    public int hashCode() {
        return Objects.hash(this.stateFilter, this.dateTimeFilter, this.fulfillmentFilter, this.sourceFilter, this.customerFilter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchOrdersFilter)) {
            return false;
        }
        SearchOrdersFilter other = (SearchOrdersFilter)obj;
        return Objects.equals(this.stateFilter, other.stateFilter) && Objects.equals(this.dateTimeFilter, other.dateTimeFilter) && Objects.equals(this.fulfillmentFilter, other.fulfillmentFilter) && Objects.equals(this.sourceFilter, other.sourceFilter) && Objects.equals(this.customerFilter, other.customerFilter);
    }

    public String toString() {
        return "SearchOrdersFilter [stateFilter=" + this.stateFilter + ", dateTimeFilter=" + this.dateTimeFilter + ", fulfillmentFilter=" + this.fulfillmentFilter + ", sourceFilter=" + this.sourceFilter + ", customerFilter=" + this.customerFilter + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().stateFilter(this.getStateFilter()).dateTimeFilter(this.getDateTimeFilter()).fulfillmentFilter(this.getFulfillmentFilter()).sourceFilter(this.getSourceFilter()).customerFilter(this.getCustomerFilter());
        return builder;
    }

    public static class Builder {
        private SearchOrdersStateFilter stateFilter;
        private SearchOrdersDateTimeFilter dateTimeFilter;
        private SearchOrdersFulfillmentFilter fulfillmentFilter;
        private SearchOrdersSourceFilter sourceFilter;
        private SearchOrdersCustomerFilter customerFilter;

        public Builder stateFilter(SearchOrdersStateFilter stateFilter) {
            this.stateFilter = stateFilter;
            return this;
        }

        public Builder dateTimeFilter(SearchOrdersDateTimeFilter dateTimeFilter) {
            this.dateTimeFilter = dateTimeFilter;
            return this;
        }

        public Builder fulfillmentFilter(SearchOrdersFulfillmentFilter fulfillmentFilter) {
            this.fulfillmentFilter = fulfillmentFilter;
            return this;
        }

        public Builder sourceFilter(SearchOrdersSourceFilter sourceFilter) {
            this.sourceFilter = sourceFilter;
            return this;
        }

        public Builder customerFilter(SearchOrdersCustomerFilter customerFilter) {
            this.customerFilter = customerFilter;
            return this;
        }

        public SearchOrdersFilter build() {
            return new SearchOrdersFilter(this.stateFilter, this.dateTimeFilter, this.fulfillmentFilter, this.sourceFilter, this.customerFilter);
        }
    }
}

