/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class SearchOrdersFulfillmentFilter {
    private final List<String> fulfillmentTypes;
    private final List<String> fulfillmentStates;

    @JsonCreator
    public SearchOrdersFulfillmentFilter(@JsonProperty(value="fulfillment_types") List<String> fulfillmentTypes, @JsonProperty(value="fulfillment_states") List<String> fulfillmentStates) {
        this.fulfillmentTypes = fulfillmentTypes;
        this.fulfillmentStates = fulfillmentStates;
    }

    @JsonGetter(value="fulfillment_types")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getFulfillmentTypes() {
        return this.fulfillmentTypes;
    }

    @JsonGetter(value="fulfillment_states")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getFulfillmentStates() {
        return this.fulfillmentStates;
    }

    public int hashCode() {
        return Objects.hash(this.fulfillmentTypes, this.fulfillmentStates);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchOrdersFulfillmentFilter)) {
            return false;
        }
        SearchOrdersFulfillmentFilter other = (SearchOrdersFulfillmentFilter)obj;
        return Objects.equals(this.fulfillmentTypes, other.fulfillmentTypes) && Objects.equals(this.fulfillmentStates, other.fulfillmentStates);
    }

    public String toString() {
        return "SearchOrdersFulfillmentFilter [fulfillmentTypes=" + this.fulfillmentTypes + ", fulfillmentStates=" + this.fulfillmentStates + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().fulfillmentTypes(this.getFulfillmentTypes()).fulfillmentStates(this.getFulfillmentStates());
        return builder;
    }

    public static class Builder {
        private List<String> fulfillmentTypes;
        private List<String> fulfillmentStates;

        public Builder fulfillmentTypes(List<String> fulfillmentTypes) {
            this.fulfillmentTypes = fulfillmentTypes;
            return this;
        }

        public Builder fulfillmentStates(List<String> fulfillmentStates) {
            this.fulfillmentStates = fulfillmentStates;
            return this;
        }

        public SearchOrdersFulfillmentFilter build() {
            return new SearchOrdersFulfillmentFilter(this.fulfillmentTypes, this.fulfillmentStates);
        }
    }
}

