/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Order;
import com.squareup.square.models.OrderEntry;
import java.util.List;
import java.util.Objects;

public class SearchOrdersResponse {
    private HttpContext httpContext;
    private final List<OrderEntry> orderEntries;
    private final List<Order> orders;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public SearchOrdersResponse(@JsonProperty(value="order_entries") List<OrderEntry> orderEntries, @JsonProperty(value="orders") List<Order> orders, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.orderEntries = orderEntries;
        this.orders = orders;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="order_entries")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderEntry> getOrderEntries() {
        return this.orderEntries;
    }

    @JsonGetter(value="orders")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Order> getOrders() {
        return this.orders;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.orderEntries, this.orders, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchOrdersResponse)) {
            return false;
        }
        SearchOrdersResponse other = (SearchOrdersResponse)obj;
        return Objects.equals(this.orderEntries, other.orderEntries) && Objects.equals(this.orders, other.orders) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "SearchOrdersResponse [orderEntries=" + this.orderEntries + ", orders=" + this.orders + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().orderEntries(this.getOrderEntries()).orders(this.getOrders()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<OrderEntry> orderEntries;
        private List<Order> orders;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder orderEntries(List<OrderEntry> orderEntries) {
            this.orderEntries = orderEntries;
            return this;
        }

        public Builder orders(List<Order> orders) {
            this.orders = orders;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public SearchOrdersResponse build() {
            SearchOrdersResponse model = new SearchOrdersResponse(this.orderEntries, this.orders, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

