/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class SearchOrdersSort {
    private final String sortField;
    private final String sortOrder;

    @JsonCreator
    public SearchOrdersSort(@JsonProperty(value="sort_field") String sortField, @JsonProperty(value="sort_order") String sortOrder) {
        this.sortField = sortField;
        this.sortOrder = sortOrder;
    }

    @JsonGetter(value="sort_field")
    public String getSortField() {
        return this.sortField;
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    public int hashCode() {
        return Objects.hash(this.sortField, this.sortOrder);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchOrdersSort)) {
            return false;
        }
        SearchOrdersSort other = (SearchOrdersSort)obj;
        return Objects.equals(this.sortField, other.sortField) && Objects.equals(this.sortOrder, other.sortOrder);
    }

    public String toString() {
        return "SearchOrdersSort [sortField=" + this.sortField + ", sortOrder=" + this.sortOrder + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.sortField).sortOrder(this.getSortOrder());
        return builder;
    }

    public static class Builder {
        private String sortField;
        private String sortOrder;

        public Builder(String sortField) {
            this.sortField = sortField;
        }

        public Builder sortField(String sortField) {
            this.sortField = sortField;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public SearchOrdersSort build() {
            return new SearchOrdersSort(this.sortField, this.sortOrder);
        }
    }
}

