/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Shift;
import java.util.List;
import java.util.Objects;

public class SearchShiftsResponse {
    private HttpContext httpContext;
    private final List<Shift> shifts;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public SearchShiftsResponse(@JsonProperty(value="shifts") List<Shift> shifts, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.shifts = shifts;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="shifts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Shift> getShifts() {
        return this.shifts;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.shifts, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchShiftsResponse)) {
            return false;
        }
        SearchShiftsResponse other = (SearchShiftsResponse)obj;
        return Objects.equals(this.shifts, other.shifts) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "SearchShiftsResponse [shifts=" + this.shifts + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().shifts(this.getShifts()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Shift> shifts;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder shifts(List<Shift> shifts) {
            this.shifts = shifts;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public SearchShiftsResponse build() {
            SearchShiftsResponse model = new SearchShiftsResponse(this.shifts, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

