/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class SearchSubscriptionsFilter {
    private final List<String> customerIds;
    private final List<String> locationIds;
    private final List<String> sourceNames;

    @JsonCreator
    public SearchSubscriptionsFilter(@JsonProperty(value="customer_ids") List<String> customerIds, @JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="source_names") List<String> sourceNames) {
        this.customerIds = customerIds;
        this.locationIds = locationIds;
        this.sourceNames = sourceNames;
    }

    @JsonGetter(value="customer_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getCustomerIds() {
        return this.customerIds;
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getLocationIds() {
        return this.locationIds;
    }

    @JsonGetter(value="source_names")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getSourceNames() {
        return this.sourceNames;
    }

    public int hashCode() {
        return Objects.hash(this.customerIds, this.locationIds, this.sourceNames);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchSubscriptionsFilter)) {
            return false;
        }
        SearchSubscriptionsFilter other = (SearchSubscriptionsFilter)obj;
        return Objects.equals(this.customerIds, other.customerIds) && Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.sourceNames, other.sourceNames);
    }

    public String toString() {
        return "SearchSubscriptionsFilter [customerIds=" + this.customerIds + ", locationIds=" + this.locationIds + ", sourceNames=" + this.sourceNames + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().customerIds(this.getCustomerIds()).locationIds(this.getLocationIds()).sourceNames(this.getSourceNames());
        return builder;
    }

    public static class Builder {
        private List<String> customerIds;
        private List<String> locationIds;
        private List<String> sourceNames;

        public Builder customerIds(List<String> customerIds) {
            this.customerIds = customerIds;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder sourceNames(List<String> sourceNames) {
            this.sourceNames = sourceNames;
            return this;
        }

        public SearchSubscriptionsFilter build() {
            return new SearchSubscriptionsFilter(this.customerIds, this.locationIds, this.sourceNames);
        }
    }
}

