/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Subscription;
import java.util.List;
import java.util.Objects;

public class SearchSubscriptionsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<Subscription> subscriptions;
    private final String cursor;

    @JsonCreator
    public SearchSubscriptionsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="subscriptions") List<Subscription> subscriptions, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.subscriptions = subscriptions;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="subscriptions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.subscriptions, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchSubscriptionsResponse)) {
            return false;
        }
        SearchSubscriptionsResponse other = (SearchSubscriptionsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.subscriptions, other.subscriptions) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "SearchSubscriptionsResponse [errors=" + this.errors + ", subscriptions=" + this.subscriptions + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).subscriptions(this.getSubscriptions()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<Subscription> subscriptions;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder subscriptions(List<Subscription> subscriptions) {
            this.subscriptions = subscriptions;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public SearchSubscriptionsResponse build() {
            SearchSubscriptionsResponse model = new SearchSubscriptionsResponse(this.errors, this.subscriptions, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

