/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class SearchTeamMembersFilter {
    private final List<String> locationIds;
    private final String status;
    private final Boolean isOwner;

    @JsonCreator
    public SearchTeamMembersFilter(@JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="status") String status, @JsonProperty(value="is_owner") Boolean isOwner) {
        this.locationIds = locationIds;
        this.status = status;
        this.isOwner = isOwner;
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getLocationIds() {
        return this.locationIds;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="is_owner")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIsOwner() {
        return this.isOwner;
    }

    public int hashCode() {
        return Objects.hash(this.locationIds, this.status, this.isOwner);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchTeamMembersFilter)) {
            return false;
        }
        SearchTeamMembersFilter other = (SearchTeamMembersFilter)obj;
        return Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.status, other.status) && Objects.equals(this.isOwner, other.isOwner);
    }

    public String toString() {
        return "SearchTeamMembersFilter [locationIds=" + this.locationIds + ", status=" + this.status + ", isOwner=" + this.isOwner + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().locationIds(this.getLocationIds()).status(this.getStatus()).isOwner(this.getIsOwner());
        return builder;
    }

    public static class Builder {
        private List<String> locationIds;
        private String status;
        private Boolean isOwner;

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder isOwner(Boolean isOwner) {
            this.isOwner = isOwner;
            return this;
        }

        public SearchTeamMembersFilter build() {
            return new SearchTeamMembersFilter(this.locationIds, this.status, this.isOwner);
        }
    }
}

