/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.TerminalActionQuery;
import java.util.Objects;

public class SearchTerminalActionsRequest {
    private final TerminalActionQuery query;
    private final String cursor;
    private final Integer limit;

    @JsonCreator
    public SearchTerminalActionsRequest(@JsonProperty(value="query") TerminalActionQuery query, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="limit") Integer limit) {
        this.query = query;
        this.cursor = cursor;
        this.limit = limit;
    }

    @JsonGetter(value="query")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TerminalActionQuery getQuery() {
        return this.query;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    public int hashCode() {
        return Objects.hash(this.query, this.cursor, this.limit);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchTerminalActionsRequest)) {
            return false;
        }
        SearchTerminalActionsRequest other = (SearchTerminalActionsRequest)obj;
        return Objects.equals(this.query, other.query) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        return "SearchTerminalActionsRequest [query=" + this.query + ", cursor=" + this.cursor + ", limit=" + this.limit + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().query(this.getQuery()).cursor(this.getCursor()).limit(this.getLimit());
        return builder;
    }

    public static class Builder {
        private TerminalActionQuery query;
        private String cursor;
        private Integer limit;

        public Builder query(TerminalActionQuery query) {
            this.query = query;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public SearchTerminalActionsRequest build() {
            return new SearchTerminalActionsRequest(this.query, this.cursor, this.limit);
        }
    }
}

