/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.TerminalAction;
import java.util.List;
import java.util.Objects;

public class SearchTerminalActionsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<TerminalAction> action;
    private final String cursor;

    @JsonCreator
    public SearchTerminalActionsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="action") List<TerminalAction> action, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.action = action;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="action")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<TerminalAction> getAction() {
        return this.action;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.action, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchTerminalActionsResponse)) {
            return false;
        }
        SearchTerminalActionsResponse other = (SearchTerminalActionsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.action, other.action) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "SearchTerminalActionsResponse [errors=" + this.errors + ", action=" + this.action + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).action(this.getAction()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<TerminalAction> action;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder action(List<TerminalAction> action) {
            this.action = action;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public SearchTerminalActionsResponse build() {
            SearchTerminalActionsResponse model = new SearchTerminalActionsResponse(this.errors, this.action, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

