/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.SearchVendorsRequestFilter;
import com.squareup.square.models.SearchVendorsRequestSort;
import java.util.Objects;

public class SearchVendorsRequest {
    private final SearchVendorsRequestFilter filter;
    private final SearchVendorsRequestSort sort;
    private final String cursor;

    @JsonCreator
    public SearchVendorsRequest(@JsonProperty(value="filter") SearchVendorsRequestFilter filter, @JsonProperty(value="sort") SearchVendorsRequestSort sort, @JsonProperty(value="cursor") String cursor) {
        this.filter = filter;
        this.sort = sort;
        this.cursor = cursor;
    }

    @JsonGetter(value="filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SearchVendorsRequestFilter getFilter() {
        return this.filter;
    }

    @JsonGetter(value="sort")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SearchVendorsRequestSort getSort() {
        return this.sort;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchVendorsRequest)) {
            return false;
        }
        SearchVendorsRequest other = (SearchVendorsRequest)obj;
        return Objects.equals(this.filter, other.filter) && Objects.equals(this.sort, other.sort) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "SearchVendorsRequest [filter=" + this.filter + ", sort=" + this.sort + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().filter(this.getFilter()).sort(this.getSort()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private SearchVendorsRequestFilter filter;
        private SearchVendorsRequestSort sort;
        private String cursor;

        public Builder filter(SearchVendorsRequestFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder sort(SearchVendorsRequestSort sort) {
            this.sort = sort;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public SearchVendorsRequest build() {
            return new SearchVendorsRequest(this.filter, this.sort, this.cursor);
        }
    }
}

