/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Vendor;
import java.util.List;
import java.util.Objects;

public class SearchVendorsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<Vendor> vendors;
    private final String cursor;

    @JsonCreator
    public SearchVendorsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="vendors") List<Vendor> vendors, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.vendors = vendors;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="vendors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Vendor> getVendors() {
        return this.vendors;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.vendors, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SearchVendorsResponse)) {
            return false;
        }
        SearchVendorsResponse other = (SearchVendorsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.vendors, other.vendors) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "SearchVendorsResponse [errors=" + this.errors + ", vendors=" + this.vendors + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).vendors(this.getVendors()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<Vendor> vendors;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder vendors(List<Vendor> vendors) {
            this.vendors = vendors;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public SearchVendorsResponse build() {
            SearchVendorsResponse model = new SearchVendorsResponse(this.errors, this.vendors, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

