/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Break;
import com.squareup.square.models.ShiftWage;
import java.util.List;
import java.util.Objects;

public class Shift {
    private final String id;
    private final String employeeId;
    private final String locationId;
    private final String timezone;
    private final String startAt;
    private final String endAt;
    private final ShiftWage wage;
    private final List<Break> breaks;
    private final String status;
    private final Integer version;
    private final String createdAt;
    private final String updatedAt;
    private final String teamMemberId;

    @JsonCreator
    public Shift(@JsonProperty(value="start_at") String startAt, @JsonProperty(value="id") String id, @JsonProperty(value="employee_id") String employeeId, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="timezone") String timezone, @JsonProperty(value="end_at") String endAt, @JsonProperty(value="wage") ShiftWage wage, @JsonProperty(value="breaks") List<Break> breaks, @JsonProperty(value="status") String status, @JsonProperty(value="version") Integer version, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="team_member_id") String teamMemberId) {
        this.id = id;
        this.employeeId = employeeId;
        this.locationId = locationId;
        this.timezone = timezone;
        this.startAt = startAt;
        this.endAt = endAt;
        this.wage = wage;
        this.breaks = breaks;
        this.status = status;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.teamMemberId = teamMemberId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="employee_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmployeeId() {
        return this.employeeId;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="timezone")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTimezone() {
        return this.timezone;
    }

    @JsonGetter(value="start_at")
    public String getStartAt() {
        return this.startAt;
    }

    @JsonGetter(value="end_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEndAt() {
        return this.endAt;
    }

    @JsonGetter(value="wage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ShiftWage getWage() {
        return this.wage;
    }

    @JsonGetter(value="breaks")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Break> getBreaks() {
        return this.breaks;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.employeeId, this.locationId, this.timezone, this.startAt, this.endAt, this.wage, this.breaks, this.status, this.version, this.createdAt, this.updatedAt, this.teamMemberId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Shift)) {
            return false;
        }
        Shift other = (Shift)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.employeeId, other.employeeId) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.timezone, other.timezone) && Objects.equals(this.startAt, other.startAt) && Objects.equals(this.endAt, other.endAt) && Objects.equals(this.wage, other.wage) && Objects.equals(this.breaks, other.breaks) && Objects.equals(this.status, other.status) && Objects.equals(this.version, other.version) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.teamMemberId, other.teamMemberId);
    }

    public String toString() {
        return "Shift [startAt=" + this.startAt + ", id=" + this.id + ", employeeId=" + this.employeeId + ", locationId=" + this.locationId + ", timezone=" + this.timezone + ", endAt=" + this.endAt + ", wage=" + this.wage + ", breaks=" + this.breaks + ", status=" + this.status + ", version=" + this.version + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", teamMemberId=" + this.teamMemberId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.startAt).id(this.getId()).employeeId(this.getEmployeeId()).locationId(this.getLocationId()).timezone(this.getTimezone()).endAt(this.getEndAt()).wage(this.getWage()).breaks(this.getBreaks()).status(this.getStatus()).version(this.getVersion()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).teamMemberId(this.getTeamMemberId());
        return builder;
    }

    public static class Builder {
        private String startAt;
        private String id;
        private String employeeId;
        private String locationId;
        private String timezone;
        private String endAt;
        private ShiftWage wage;
        private List<Break> breaks;
        private String status;
        private Integer version;
        private String createdAt;
        private String updatedAt;
        private String teamMemberId;

        public Builder(String startAt) {
            this.startAt = startAt;
        }

        public Builder startAt(String startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder employeeId(String employeeId) {
            this.employeeId = employeeId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder endAt(String endAt) {
            this.endAt = endAt;
            return this;
        }

        public Builder wage(ShiftWage wage) {
            this.wage = wage;
            return this;
        }

        public Builder breaks(List<Break> breaks) {
            this.breaks = breaks;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Shift build() {
            return new Shift(this.startAt, this.id, this.employeeId, this.locationId, this.timezone, this.endAt, this.wage, this.breaks, this.status, this.version, this.createdAt, this.updatedAt, this.teamMemberId);
        }
    }
}

