/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.ShiftWorkday;
import com.squareup.square.models.TimeRange;
import java.util.List;
import java.util.Objects;

public class ShiftFilter {
    private final List<String> locationIds;
    private final List<String> employeeIds;
    private final String status;
    private final TimeRange start;
    private final TimeRange end;
    private final ShiftWorkday workday;
    private final List<String> teamMemberIds;

    @JsonCreator
    public ShiftFilter(@JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="team_member_ids") List<String> teamMemberIds, @JsonProperty(value="employee_ids") List<String> employeeIds, @JsonProperty(value="status") String status, @JsonProperty(value="start") TimeRange start, @JsonProperty(value="end") TimeRange end, @JsonProperty(value="workday") ShiftWorkday workday) {
        this.locationIds = locationIds;
        this.employeeIds = employeeIds;
        this.status = status;
        this.start = start;
        this.end = end;
        this.workday = workday;
        this.teamMemberIds = teamMemberIds;
    }

    @JsonGetter(value="location_ids")
    public List<String> getLocationIds() {
        return this.locationIds;
    }

    @JsonGetter(value="employee_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getEmployeeIds() {
        return this.employeeIds;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="start")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TimeRange getStart() {
        return this.start;
    }

    @JsonGetter(value="end")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TimeRange getEnd() {
        return this.end;
    }

    @JsonGetter(value="workday")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ShiftWorkday getWorkday() {
        return this.workday;
    }

    @JsonGetter(value="team_member_ids")
    public List<String> getTeamMemberIds() {
        return this.teamMemberIds;
    }

    public int hashCode() {
        return Objects.hash(this.locationIds, this.employeeIds, this.status, this.start, this.end, this.workday, this.teamMemberIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShiftFilter)) {
            return false;
        }
        ShiftFilter other = (ShiftFilter)obj;
        return Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.employeeIds, other.employeeIds) && Objects.equals(this.status, other.status) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.workday, other.workday) && Objects.equals(this.teamMemberIds, other.teamMemberIds);
    }

    public String toString() {
        return "ShiftFilter [locationIds=" + this.locationIds + ", teamMemberIds=" + this.teamMemberIds + ", employeeIds=" + this.employeeIds + ", status=" + this.status + ", start=" + this.start + ", end=" + this.end + ", workday=" + this.workday + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.locationIds, this.teamMemberIds).employeeIds(this.getEmployeeIds()).status(this.getStatus()).start(this.getStart()).end(this.getEnd()).workday(this.getWorkday());
        return builder;
    }

    public static class Builder {
        private List<String> locationIds;
        private List<String> teamMemberIds;
        private List<String> employeeIds;
        private String status;
        private TimeRange start;
        private TimeRange end;
        private ShiftWorkday workday;

        public Builder(List<String> locationIds, List<String> teamMemberIds) {
            this.locationIds = locationIds;
            this.teamMemberIds = teamMemberIds;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder teamMemberIds(List<String> teamMemberIds) {
            this.teamMemberIds = teamMemberIds;
            return this;
        }

        public Builder employeeIds(List<String> employeeIds) {
            this.employeeIds = employeeIds;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder start(TimeRange start) {
            this.start = start;
            return this;
        }

        public Builder end(TimeRange end) {
            this.end = end;
            return this;
        }

        public Builder workday(ShiftWorkday workday) {
            this.workday = workday;
            return this;
        }

        public ShiftFilter build() {
            return new ShiftFilter(this.locationIds, this.teamMemberIds, this.employeeIds, this.status, this.start, this.end, this.workday);
        }
    }
}

