/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.ShiftFilter;
import com.squareup.square.models.ShiftSort;
import java.util.Objects;

public class ShiftQuery {
    private final ShiftFilter filter;
    private final ShiftSort sort;

    @JsonCreator
    public ShiftQuery(@JsonProperty(value="filter") ShiftFilter filter, @JsonProperty(value="sort") ShiftSort sort) {
        this.filter = filter;
        this.sort = sort;
    }

    @JsonGetter(value="filter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ShiftFilter getFilter() {
        return this.filter;
    }

    @JsonGetter(value="sort")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ShiftSort getSort() {
        return this.sort;
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.sort);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShiftQuery)) {
            return false;
        }
        ShiftQuery other = (ShiftQuery)obj;
        return Objects.equals(this.filter, other.filter) && Objects.equals(this.sort, other.sort);
    }

    public String toString() {
        return "ShiftQuery [filter=" + this.filter + ", sort=" + this.sort + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().filter(this.getFilter()).sort(this.getSort());
        return builder;
    }

    public static class Builder {
        private ShiftFilter filter;
        private ShiftSort sort;

        public Builder filter(ShiftFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder sort(ShiftSort sort) {
            this.sort = sort;
            return this;
        }

        public ShiftQuery build() {
            return new ShiftQuery(this.filter, this.sort);
        }
    }
}

