/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class ShiftWage {
    private final String title;
    private final Money hourlyRate;

    @JsonCreator
    public ShiftWage(@JsonProperty(value="title") String title, @JsonProperty(value="hourly_rate") Money hourlyRate) {
        this.title = title;
        this.hourlyRate = hourlyRate;
    }

    @JsonGetter(value="title")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTitle() {
        return this.title;
    }

    @JsonGetter(value="hourly_rate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getHourlyRate() {
        return this.hourlyRate;
    }

    public int hashCode() {
        return Objects.hash(this.title, this.hourlyRate);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShiftWage)) {
            return false;
        }
        ShiftWage other = (ShiftWage)obj;
        return Objects.equals(this.title, other.title) && Objects.equals(this.hourlyRate, other.hourlyRate);
    }

    public String toString() {
        return "ShiftWage [title=" + this.title + ", hourlyRate=" + this.hourlyRate + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().title(this.getTitle()).hourlyRate(this.getHourlyRate());
        return builder;
    }

    public static class Builder {
        private String title;
        private Money hourlyRate;

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder hourlyRate(Money hourlyRate) {
            this.hourlyRate = hourlyRate;
            return this;
        }

        public ShiftWage build() {
            return new ShiftWage(this.title, this.hourlyRate);
        }
    }
}

