/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class Snippet {
    private final String id;
    private final String siteId;
    private final String content;
    private final String createdAt;
    private final String updatedAt;

    @JsonCreator
    public Snippet(@JsonProperty(value="content") String content, @JsonProperty(value="id") String id, @JsonProperty(value="site_id") String siteId, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt) {
        this.id = id;
        this.siteId = siteId;
        this.content = content;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="site_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSiteId() {
        return this.siteId;
    }

    @JsonGetter(value="content")
    public String getContent() {
        return this.content;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.siteId, this.content, this.createdAt, this.updatedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Snippet)) {
            return false;
        }
        Snippet other = (Snippet)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.siteId, other.siteId) && Objects.equals(this.content, other.content) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt);
    }

    public String toString() {
        return "Snippet [content=" + this.content + ", id=" + this.id + ", siteId=" + this.siteId + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.content).id(this.getId()).siteId(this.getSiteId()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt());
        return builder;
    }

    public static class Builder {
        private String content;
        private String id;
        private String siteId;
        private String createdAt;
        private String updatedAt;

        public Builder(String content) {
            this.content = content;
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Snippet build() {
            return new Snippet(this.content, this.id, this.siteId, this.createdAt, this.updatedAt);
        }
    }
}

