/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.MeasurementUnit;
import java.util.Objects;

public class StandardUnitDescription {
    private final MeasurementUnit unit;
    private final String name;
    private final String abbreviation;

    @JsonCreator
    public StandardUnitDescription(@JsonProperty(value="unit") MeasurementUnit unit, @JsonProperty(value="name") String name, @JsonProperty(value="abbreviation") String abbreviation) {
        this.unit = unit;
        this.name = name;
        this.abbreviation = abbreviation;
    }

    @JsonGetter(value="unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public MeasurementUnit getUnit() {
        return this.unit;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="abbreviation")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAbbreviation() {
        return this.abbreviation;
    }

    public int hashCode() {
        return Objects.hash(this.unit, this.name, this.abbreviation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardUnitDescription)) {
            return false;
        }
        StandardUnitDescription other = (StandardUnitDescription)obj;
        return Objects.equals(this.unit, other.unit) && Objects.equals(this.name, other.name) && Objects.equals(this.abbreviation, other.abbreviation);
    }

    public String toString() {
        return "StandardUnitDescription [unit=" + this.unit + ", name=" + this.name + ", abbreviation=" + this.abbreviation + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().unit(this.getUnit()).name(this.getName()).abbreviation(this.getAbbreviation());
        return builder;
    }

    public static class Builder {
        private MeasurementUnit unit;
        private String name;
        private String abbreviation;

        public Builder unit(MeasurementUnit unit) {
            this.unit = unit;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder abbreviation(String abbreviation) {
            this.abbreviation = abbreviation;
            return this;
        }

        public StandardUnitDescription build() {
            return new StandardUnitDescription(this.unit, this.name, this.abbreviation);
        }
    }
}

