/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.StandardUnitDescription;
import java.util.List;
import java.util.Objects;

public class StandardUnitDescriptionGroup {
    private final List<StandardUnitDescription> standardUnitDescriptions;
    private final String languageCode;

    @JsonCreator
    public StandardUnitDescriptionGroup(@JsonProperty(value="standard_unit_descriptions") List<StandardUnitDescription> standardUnitDescriptions, @JsonProperty(value="language_code") String languageCode) {
        this.standardUnitDescriptions = standardUnitDescriptions;
        this.languageCode = languageCode;
    }

    @JsonGetter(value="standard_unit_descriptions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<StandardUnitDescription> getStandardUnitDescriptions() {
        return this.standardUnitDescriptions;
    }

    @JsonGetter(value="language_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLanguageCode() {
        return this.languageCode;
    }

    public int hashCode() {
        return Objects.hash(this.standardUnitDescriptions, this.languageCode);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardUnitDescriptionGroup)) {
            return false;
        }
        StandardUnitDescriptionGroup other = (StandardUnitDescriptionGroup)obj;
        return Objects.equals(this.standardUnitDescriptions, other.standardUnitDescriptions) && Objects.equals(this.languageCode, other.languageCode);
    }

    public String toString() {
        return "StandardUnitDescriptionGroup [standardUnitDescriptions=" + this.standardUnitDescriptions + ", languageCode=" + this.languageCode + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().standardUnitDescriptions(this.getStandardUnitDescriptions()).languageCode(this.getLanguageCode());
        return builder;
    }

    public static class Builder {
        private List<StandardUnitDescription> standardUnitDescriptions;
        private String languageCode;

        public Builder standardUnitDescriptions(List<StandardUnitDescription> standardUnitDescriptions) {
            this.standardUnitDescriptions = standardUnitDescriptions;
            return this;
        }

        public Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public StandardUnitDescriptionGroup build() {
            return new StandardUnitDescriptionGroup(this.standardUnitDescriptions, this.languageCode);
        }
    }
}

