/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class SubscriptionAction {
    private final String id;
    private final String type;
    private final String effectiveDate;
    private final String newPlanId;

    @JsonCreator
    public SubscriptionAction(@JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="effective_date") String effectiveDate, @JsonProperty(value="new_plan_id") String newPlanId) {
        this.id = id;
        this.type = type;
        this.effectiveDate = effectiveDate;
        this.newPlanId = newPlanId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="effective_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonGetter(value="new_plan_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNewPlanId() {
        return this.newPlanId;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.effectiveDate, this.newPlanId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SubscriptionAction)) {
            return false;
        }
        SubscriptionAction other = (SubscriptionAction)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.type, other.type) && Objects.equals(this.effectiveDate, other.effectiveDate) && Objects.equals(this.newPlanId, other.newPlanId);
    }

    public String toString() {
        return "SubscriptionAction [id=" + this.id + ", type=" + this.type + ", effectiveDate=" + this.effectiveDate + ", newPlanId=" + this.newPlanId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).type(this.getType()).effectiveDate(this.getEffectiveDate()).newPlanId(this.getNewPlanId());
        return builder;
    }

    public static class Builder {
        private String id;
        private String type;
        private String effectiveDate;
        private String newPlanId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder effectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public Builder newPlanId(String newPlanId) {
            this.newPlanId = newPlanId;
            return this;
        }

        public SubscriptionAction build() {
            return new SubscriptionAction(this.id, this.type, this.effectiveDate, this.newPlanId);
        }
    }
}

