/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.SubscriptionEventInfo;
import java.util.Objects;

public class SubscriptionEvent {
    private final String id;
    private final String subscriptionEventType;
    private final String effectiveDate;
    private final String planId;
    private final SubscriptionEventInfo info;

    @JsonCreator
    public SubscriptionEvent(@JsonProperty(value="id") String id, @JsonProperty(value="subscription_event_type") String subscriptionEventType, @JsonProperty(value="effective_date") String effectiveDate, @JsonProperty(value="plan_id") String planId, @JsonProperty(value="info") SubscriptionEventInfo info) {
        this.id = id;
        this.subscriptionEventType = subscriptionEventType;
        this.effectiveDate = effectiveDate;
        this.planId = planId;
        this.info = info;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="subscription_event_type")
    public String getSubscriptionEventType() {
        return this.subscriptionEventType;
    }

    @JsonGetter(value="effective_date")
    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonGetter(value="plan_id")
    public String getPlanId() {
        return this.planId;
    }

    @JsonGetter(value="info")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SubscriptionEventInfo getInfo() {
        return this.info;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.subscriptionEventType, this.effectiveDate, this.planId, this.info);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SubscriptionEvent)) {
            return false;
        }
        SubscriptionEvent other = (SubscriptionEvent)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.subscriptionEventType, other.subscriptionEventType) && Objects.equals(this.effectiveDate, other.effectiveDate) && Objects.equals(this.planId, other.planId) && Objects.equals(this.info, other.info);
    }

    public String toString() {
        return "SubscriptionEvent [id=" + this.id + ", subscriptionEventType=" + this.subscriptionEventType + ", effectiveDate=" + this.effectiveDate + ", planId=" + this.planId + ", info=" + this.info + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.subscriptionEventType, this.effectiveDate, this.planId).info(this.getInfo());
        return builder;
    }

    public static class Builder {
        private String id;
        private String subscriptionEventType;
        private String effectiveDate;
        private String planId;
        private SubscriptionEventInfo info;

        public Builder(String id, String subscriptionEventType, String effectiveDate, String planId) {
            this.id = id;
            this.subscriptionEventType = subscriptionEventType;
            this.effectiveDate = effectiveDate;
            this.planId = planId;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder subscriptionEventType(String subscriptionEventType) {
            this.subscriptionEventType = subscriptionEventType;
            return this;
        }

        public Builder effectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public Builder planId(String planId) {
            this.planId = planId;
            return this;
        }

        public Builder info(SubscriptionEventInfo info) {
            this.info = info;
            return this;
        }

        public SubscriptionEvent build() {
            return new SubscriptionEvent(this.id, this.subscriptionEventType, this.effectiveDate, this.planId, this.info);
        }
    }
}

