/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class SubscriptionPhase {
    private final String uid;
    private final String cadence;
    private final Integer periods;
    private final Money recurringPriceMoney;
    private final Long ordinal;

    @JsonCreator
    public SubscriptionPhase(@JsonProperty(value="cadence") String cadence, @JsonProperty(value="recurring_price_money") Money recurringPriceMoney, @JsonProperty(value="uid") String uid, @JsonProperty(value="periods") Integer periods, @JsonProperty(value="ordinal") Long ordinal) {
        this.uid = uid;
        this.cadence = cadence;
        this.periods = periods;
        this.recurringPriceMoney = recurringPriceMoney;
        this.ordinal = ordinal;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="cadence")
    public String getCadence() {
        return this.cadence;
    }

    @JsonGetter(value="periods")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getPeriods() {
        return this.periods;
    }

    @JsonGetter(value="recurring_price_money")
    public Money getRecurringPriceMoney() {
        return this.recurringPriceMoney;
    }

    @JsonGetter(value="ordinal")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getOrdinal() {
        return this.ordinal;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.cadence, this.periods, this.recurringPriceMoney, this.ordinal);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SubscriptionPhase)) {
            return false;
        }
        SubscriptionPhase other = (SubscriptionPhase)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.cadence, other.cadence) && Objects.equals(this.periods, other.periods) && Objects.equals(this.recurringPriceMoney, other.recurringPriceMoney) && Objects.equals(this.ordinal, other.ordinal);
    }

    public String toString() {
        return "SubscriptionPhase [cadence=" + this.cadence + ", recurringPriceMoney=" + this.recurringPriceMoney + ", uid=" + this.uid + ", periods=" + this.periods + ", ordinal=" + this.ordinal + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.cadence, this.recurringPriceMoney).uid(this.getUid()).periods(this.getPeriods()).ordinal(this.getOrdinal());
        return builder;
    }

    public static class Builder {
        private String cadence;
        private Money recurringPriceMoney;
        private String uid;
        private Integer periods;
        private Long ordinal;

        public Builder(String cadence, Money recurringPriceMoney) {
            this.cadence = cadence;
            this.recurringPriceMoney = recurringPriceMoney;
        }

        public Builder cadence(String cadence) {
            this.cadence = cadence;
            return this;
        }

        public Builder recurringPriceMoney(Money recurringPriceMoney) {
            this.recurringPriceMoney = recurringPriceMoney;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder periods(Integer periods) {
            this.periods = periods;
            return this;
        }

        public Builder ordinal(Long ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public SubscriptionPhase build() {
            return new SubscriptionPhase(this.cadence, this.recurringPriceMoney, this.uid, this.periods, this.ordinal);
        }
    }
}

