/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class TaxIds {
    private final String euVat;
    private final String frSiret;
    private final String frNaf;
    private final String esNif;

    @JsonCreator
    public TaxIds(@JsonProperty(value="eu_vat") String euVat, @JsonProperty(value="fr_siret") String frSiret, @JsonProperty(value="fr_naf") String frNaf, @JsonProperty(value="es_nif") String esNif) {
        this.euVat = euVat;
        this.frSiret = frSiret;
        this.frNaf = frNaf;
        this.esNif = esNif;
    }

    @JsonGetter(value="eu_vat")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEuVat() {
        return this.euVat;
    }

    @JsonGetter(value="fr_siret")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFrSiret() {
        return this.frSiret;
    }

    @JsonGetter(value="fr_naf")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFrNaf() {
        return this.frNaf;
    }

    @JsonGetter(value="es_nif")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEsNif() {
        return this.esNif;
    }

    public int hashCode() {
        return Objects.hash(this.euVat, this.frSiret, this.frNaf, this.esNif);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TaxIds)) {
            return false;
        }
        TaxIds other = (TaxIds)obj;
        return Objects.equals(this.euVat, other.euVat) && Objects.equals(this.frSiret, other.frSiret) && Objects.equals(this.frNaf, other.frNaf) && Objects.equals(this.esNif, other.esNif);
    }

    public String toString() {
        return "TaxIds [euVat=" + this.euVat + ", frSiret=" + this.frSiret + ", frNaf=" + this.frNaf + ", esNif=" + this.esNif + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().euVat(this.getEuVat()).frSiret(this.getFrSiret()).frNaf(this.getFrNaf()).esNif(this.getEsNif());
        return builder;
    }

    public static class Builder {
        private String euVat;
        private String frSiret;
        private String frNaf;
        private String esNif;

        public Builder euVat(String euVat) {
            this.euVat = euVat;
            return this;
        }

        public Builder frSiret(String frSiret) {
            this.frSiret = frSiret;
            return this;
        }

        public Builder frNaf(String frNaf) {
            this.frNaf = frNaf;
            return this;
        }

        public Builder esNif(String esNif) {
            this.esNif = esNif;
            return this;
        }

        public TaxIds build() {
            return new TaxIds(this.euVat, this.frSiret, this.frNaf, this.esNif);
        }
    }
}

