/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.TeamMemberAssignedLocations;
import java.util.Objects;

public class TeamMember {
    private final String id;
    private final String referenceId;
    private final Boolean isOwner;
    private final String status;
    private final String givenName;
    private final String familyName;
    private final String emailAddress;
    private final String phoneNumber;
    private final String createdAt;
    private final String updatedAt;
    private final TeamMemberAssignedLocations assignedLocations;

    @JsonCreator
    public TeamMember(@JsonProperty(value="id") String id, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="is_owner") Boolean isOwner, @JsonProperty(value="status") String status, @JsonProperty(value="given_name") String givenName, @JsonProperty(value="family_name") String familyName, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="assigned_locations") TeamMemberAssignedLocations assignedLocations) {
        this.id = id;
        this.referenceId = referenceId;
        this.isOwner = isOwner;
        this.status = status;
        this.givenName = givenName;
        this.familyName = familyName;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.assignedLocations = assignedLocations;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="is_owner")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIsOwner() {
        return this.isOwner;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="given_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getGivenName() {
        return this.givenName;
    }

    @JsonGetter(value="family_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFamilyName() {
        return this.familyName;
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonGetter(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="assigned_locations")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TeamMemberAssignedLocations getAssignedLocations() {
        return this.assignedLocations;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.referenceId, this.isOwner, this.status, this.givenName, this.familyName, this.emailAddress, this.phoneNumber, this.createdAt, this.updatedAt, this.assignedLocations);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TeamMember)) {
            return false;
        }
        TeamMember other = (TeamMember)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.isOwner, other.isOwner) && Objects.equals(this.status, other.status) && Objects.equals(this.givenName, other.givenName) && Objects.equals(this.familyName, other.familyName) && Objects.equals(this.emailAddress, other.emailAddress) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.assignedLocations, other.assignedLocations);
    }

    public String toString() {
        return "TeamMember [id=" + this.id + ", referenceId=" + this.referenceId + ", isOwner=" + this.isOwner + ", status=" + this.status + ", givenName=" + this.givenName + ", familyName=" + this.familyName + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", assignedLocations=" + this.assignedLocations + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).referenceId(this.getReferenceId()).isOwner(this.getIsOwner()).status(this.getStatus()).givenName(this.getGivenName()).familyName(this.getFamilyName()).emailAddress(this.getEmailAddress()).phoneNumber(this.getPhoneNumber()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).assignedLocations(this.getAssignedLocations());
        return builder;
    }

    public static class Builder {
        private String id;
        private String referenceId;
        private Boolean isOwner;
        private String status;
        private String givenName;
        private String familyName;
        private String emailAddress;
        private String phoneNumber;
        private String createdAt;
        private String updatedAt;
        private TeamMemberAssignedLocations assignedLocations;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder isOwner(Boolean isOwner) {
            this.isOwner = isOwner;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder familyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder assignedLocations(TeamMemberAssignedLocations assignedLocations) {
            this.assignedLocations = assignedLocations;
            return this;
        }

        public TeamMember build() {
            return new TeamMember(this.id, this.referenceId, this.isOwner, this.status, this.givenName, this.familyName, this.emailAddress, this.phoneNumber, this.createdAt, this.updatedAt, this.assignedLocations);
        }
    }
}

