/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class TeamMemberWage {
    private final String id;
    private final String teamMemberId;
    private final String title;
    private final Money hourlyRate;

    @JsonCreator
    public TeamMemberWage(@JsonProperty(value="id") String id, @JsonProperty(value="team_member_id") String teamMemberId, @JsonProperty(value="title") String title, @JsonProperty(value="hourly_rate") Money hourlyRate) {
        this.id = id;
        this.teamMemberId = teamMemberId;
        this.title = title;
        this.hourlyRate = hourlyRate;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonGetter(value="title")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTitle() {
        return this.title;
    }

    @JsonGetter(value="hourly_rate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getHourlyRate() {
        return this.hourlyRate;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.teamMemberId, this.title, this.hourlyRate);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TeamMemberWage)) {
            return false;
        }
        TeamMemberWage other = (TeamMemberWage)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.teamMemberId, other.teamMemberId) && Objects.equals(this.title, other.title) && Objects.equals(this.hourlyRate, other.hourlyRate);
    }

    public String toString() {
        return "TeamMemberWage [id=" + this.id + ", teamMemberId=" + this.teamMemberId + ", title=" + this.title + ", hourlyRate=" + this.hourlyRate + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).teamMemberId(this.getTeamMemberId()).title(this.getTitle()).hourlyRate(this.getHourlyRate());
        return builder;
    }

    public static class Builder {
        private String id;
        private String teamMemberId;
        private String title;
        private Money hourlyRate;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder hourlyRate(Money hourlyRate) {
            this.hourlyRate = hourlyRate;
            return this;
        }

        public TeamMemberWage build() {
            return new TeamMemberWage(this.id, this.teamMemberId, this.title, this.hourlyRate);
        }
    }
}

