/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.AdditionalRecipient;
import com.squareup.square.models.Money;
import com.squareup.square.models.TenderCardDetails;
import com.squareup.square.models.TenderCashDetails;
import java.util.List;
import java.util.Objects;

public class Tender {
    private final String id;
    private final String locationId;
    private final String transactionId;
    private final String createdAt;
    private final String note;
    private final Money amountMoney;
    private final Money tipMoney;
    private final Money processingFeeMoney;
    private final String customerId;
    private final String type;
    private final TenderCardDetails cardDetails;
    private final TenderCashDetails cashDetails;
    private final List<AdditionalRecipient> additionalRecipients;
    private final String paymentId;

    @JsonCreator
    public Tender(@JsonProperty(value="type") String type, @JsonProperty(value="id") String id, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="transaction_id") String transactionId, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="note") String note, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="tip_money") Money tipMoney, @JsonProperty(value="processing_fee_money") Money processingFeeMoney, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="card_details") TenderCardDetails cardDetails, @JsonProperty(value="cash_details") TenderCashDetails cashDetails, @JsonProperty(value="additional_recipients") List<AdditionalRecipient> additionalRecipients, @JsonProperty(value="payment_id") String paymentId) {
        this.id = id;
        this.locationId = locationId;
        this.transactionId = transactionId;
        this.createdAt = createdAt;
        this.note = note;
        this.amountMoney = amountMoney;
        this.tipMoney = tipMoney;
        this.processingFeeMoney = processingFeeMoney;
        this.customerId = customerId;
        this.type = type;
        this.cardDetails = cardDetails;
        this.cashDetails = cashDetails;
        this.additionalRecipients = additionalRecipients;
        this.paymentId = paymentId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="transaction_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTransactionId() {
        return this.transactionId;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNote() {
        return this.note;
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="tip_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTipMoney() {
        return this.tipMoney;
    }

    @JsonGetter(value="processing_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getProcessingFeeMoney() {
        return this.processingFeeMoney;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonGetter(value="type")
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="card_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TenderCardDetails getCardDetails() {
        return this.cardDetails;
    }

    @JsonGetter(value="cash_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TenderCashDetails getCashDetails() {
        return this.cashDetails;
    }

    @JsonGetter(value="additional_recipients")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<AdditionalRecipient> getAdditionalRecipients() {
        return this.additionalRecipients;
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaymentId() {
        return this.paymentId;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.transactionId, this.createdAt, this.note, this.amountMoney, this.tipMoney, this.processingFeeMoney, this.customerId, this.type, this.cardDetails, this.cashDetails, this.additionalRecipients, this.paymentId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Tender)) {
            return false;
        }
        Tender other = (Tender)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.transactionId, other.transactionId) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.note, other.note) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.tipMoney, other.tipMoney) && Objects.equals(this.processingFeeMoney, other.processingFeeMoney) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.type, other.type) && Objects.equals(this.cardDetails, other.cardDetails) && Objects.equals(this.cashDetails, other.cashDetails) && Objects.equals(this.additionalRecipients, other.additionalRecipients) && Objects.equals(this.paymentId, other.paymentId);
    }

    public String toString() {
        return "Tender [type=" + this.type + ", id=" + this.id + ", locationId=" + this.locationId + ", transactionId=" + this.transactionId + ", createdAt=" + this.createdAt + ", note=" + this.note + ", amountMoney=" + this.amountMoney + ", tipMoney=" + this.tipMoney + ", processingFeeMoney=" + this.processingFeeMoney + ", customerId=" + this.customerId + ", cardDetails=" + this.cardDetails + ", cashDetails=" + this.cashDetails + ", additionalRecipients=" + this.additionalRecipients + ", paymentId=" + this.paymentId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.type).id(this.getId()).locationId(this.getLocationId()).transactionId(this.getTransactionId()).createdAt(this.getCreatedAt()).note(this.getNote()).amountMoney(this.getAmountMoney()).tipMoney(this.getTipMoney()).processingFeeMoney(this.getProcessingFeeMoney()).customerId(this.getCustomerId()).cardDetails(this.getCardDetails()).cashDetails(this.getCashDetails()).additionalRecipients(this.getAdditionalRecipients()).paymentId(this.getPaymentId());
        return builder;
    }

    public static class Builder {
        private String type;
        private String id;
        private String locationId;
        private String transactionId;
        private String createdAt;
        private String note;
        private Money amountMoney;
        private Money tipMoney;
        private Money processingFeeMoney;
        private String customerId;
        private TenderCardDetails cardDetails;
        private TenderCashDetails cashDetails;
        private List<AdditionalRecipient> additionalRecipients;
        private String paymentId;

        public Builder(String type) {
            this.type = type;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder tipMoney(Money tipMoney) {
            this.tipMoney = tipMoney;
            return this;
        }

        public Builder processingFeeMoney(Money processingFeeMoney) {
            this.processingFeeMoney = processingFeeMoney;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder cardDetails(TenderCardDetails cardDetails) {
            this.cardDetails = cardDetails;
            return this;
        }

        public Builder cashDetails(TenderCashDetails cashDetails) {
            this.cashDetails = cashDetails;
            return this;
        }

        public Builder additionalRecipients(List<AdditionalRecipient> additionalRecipients) {
            this.additionalRecipients = additionalRecipients;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Tender build() {
            return new Tender(this.type, this.id, this.locationId, this.transactionId, this.createdAt, this.note, this.amountMoney, this.tipMoney, this.processingFeeMoney, this.customerId, this.cardDetails, this.cashDetails, this.additionalRecipients, this.paymentId);
        }
    }
}

