/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Card;
import java.util.Objects;

public class TenderCardDetails {
    private final String status;
    private final Card card;
    private final String entryMethod;

    @JsonCreator
    public TenderCardDetails(@JsonProperty(value="status") String status, @JsonProperty(value="card") Card card, @JsonProperty(value="entry_method") String entryMethod) {
        this.status = status;
        this.card = card;
        this.entryMethod = entryMethod;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="card")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Card getCard() {
        return this.card;
    }

    @JsonGetter(value="entry_method")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEntryMethod() {
        return this.entryMethod;
    }

    public int hashCode() {
        return Objects.hash(this.status, this.card, this.entryMethod);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TenderCardDetails)) {
            return false;
        }
        TenderCardDetails other = (TenderCardDetails)obj;
        return Objects.equals(this.status, other.status) && Objects.equals(this.card, other.card) && Objects.equals(this.entryMethod, other.entryMethod);
    }

    public String toString() {
        return "TenderCardDetails [status=" + this.status + ", card=" + this.card + ", entryMethod=" + this.entryMethod + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().status(this.getStatus()).card(this.getCard()).entryMethod(this.getEntryMethod());
        return builder;
    }

    public static class Builder {
        private String status;
        private Card card;
        private String entryMethod;

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder card(Card card) {
            this.card = card;
            return this;
        }

        public Builder entryMethod(String entryMethod) {
            this.entryMethod = entryMethod;
            return this;
        }

        public TenderCardDetails build() {
            return new TenderCardDetails(this.status, this.card, this.entryMethod);
        }
    }
}

