/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.DeviceCheckoutOptions;
import com.squareup.square.models.Money;
import com.squareup.square.models.PaymentOptions;
import java.util.List;
import java.util.Objects;

public class TerminalCheckout {
    private final String id;
    private final Money amountMoney;
    private final String referenceId;
    private final String note;
    private final String orderId;
    private final PaymentOptions paymentOptions;
    private final DeviceCheckoutOptions deviceOptions;
    private final String deadlineDuration;
    private final String status;
    private final String cancelReason;
    private final List<String> paymentIds;
    private final String createdAt;
    private final String updatedAt;
    private final String appId;
    private final String locationId;
    private final String paymentType;
    private final String customerId;
    private final Money appFeeMoney;

    @JsonCreator
    public TerminalCheckout(@JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="device_options") DeviceCheckoutOptions deviceOptions, @JsonProperty(value="id") String id, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="note") String note, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="payment_options") PaymentOptions paymentOptions, @JsonProperty(value="deadline_duration") String deadlineDuration, @JsonProperty(value="status") String status, @JsonProperty(value="cancel_reason") String cancelReason, @JsonProperty(value="payment_ids") List<String> paymentIds, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="app_id") String appId, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="payment_type") String paymentType, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="app_fee_money") Money appFeeMoney) {
        this.id = id;
        this.amountMoney = amountMoney;
        this.referenceId = referenceId;
        this.note = note;
        this.orderId = orderId;
        this.paymentOptions = paymentOptions;
        this.deviceOptions = deviceOptions;
        this.deadlineDuration = deadlineDuration;
        this.status = status;
        this.cancelReason = cancelReason;
        this.paymentIds = paymentIds;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.appId = appId;
        this.locationId = locationId;
        this.paymentType = paymentType;
        this.customerId = customerId;
        this.appFeeMoney = appFeeMoney;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNote() {
        return this.note;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonGetter(value="payment_options")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PaymentOptions getPaymentOptions() {
        return this.paymentOptions;
    }

    @JsonGetter(value="device_options")
    public DeviceCheckoutOptions getDeviceOptions() {
        return this.deviceOptions;
    }

    @JsonGetter(value="deadline_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDeadlineDuration() {
        return this.deadlineDuration;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="cancel_reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCancelReason() {
        return this.cancelReason;
    }

    @JsonGetter(value="payment_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getPaymentIds() {
        return this.paymentIds;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="app_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAppId() {
        return this.appId;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="payment_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaymentType() {
        return this.paymentType;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonGetter(value="app_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppFeeMoney() {
        return this.appFeeMoney;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.amountMoney, this.referenceId, this.note, this.orderId, this.paymentOptions, this.deviceOptions, this.deadlineDuration, this.status, this.cancelReason, this.paymentIds, this.createdAt, this.updatedAt, this.appId, this.locationId, this.paymentType, this.customerId, this.appFeeMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TerminalCheckout)) {
            return false;
        }
        TerminalCheckout other = (TerminalCheckout)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.note, other.note) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.paymentOptions, other.paymentOptions) && Objects.equals(this.deviceOptions, other.deviceOptions) && Objects.equals(this.deadlineDuration, other.deadlineDuration) && Objects.equals(this.status, other.status) && Objects.equals(this.cancelReason, other.cancelReason) && Objects.equals(this.paymentIds, other.paymentIds) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.appId, other.appId) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.paymentType, other.paymentType) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.appFeeMoney, other.appFeeMoney);
    }

    public String toString() {
        return "TerminalCheckout [amountMoney=" + this.amountMoney + ", deviceOptions=" + this.deviceOptions + ", id=" + this.id + ", referenceId=" + this.referenceId + ", note=" + this.note + ", orderId=" + this.orderId + ", paymentOptions=" + this.paymentOptions + ", deadlineDuration=" + this.deadlineDuration + ", status=" + this.status + ", cancelReason=" + this.cancelReason + ", paymentIds=" + this.paymentIds + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", appId=" + this.appId + ", locationId=" + this.locationId + ", paymentType=" + this.paymentType + ", customerId=" + this.customerId + ", appFeeMoney=" + this.appFeeMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.amountMoney, this.deviceOptions).id(this.getId()).referenceId(this.getReferenceId()).note(this.getNote()).orderId(this.getOrderId()).paymentOptions(this.getPaymentOptions()).deadlineDuration(this.getDeadlineDuration()).status(this.getStatus()).cancelReason(this.getCancelReason()).paymentIds(this.getPaymentIds()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).appId(this.getAppId()).locationId(this.getLocationId()).paymentType(this.getPaymentType()).customerId(this.getCustomerId()).appFeeMoney(this.getAppFeeMoney());
        return builder;
    }

    public static class Builder {
        private Money amountMoney;
        private DeviceCheckoutOptions deviceOptions;
        private String id;
        private String referenceId;
        private String note;
        private String orderId;
        private PaymentOptions paymentOptions;
        private String deadlineDuration;
        private String status;
        private String cancelReason;
        private List<String> paymentIds;
        private String createdAt;
        private String updatedAt;
        private String appId;
        private String locationId;
        private String paymentType;
        private String customerId;
        private Money appFeeMoney;

        public Builder(Money amountMoney, DeviceCheckoutOptions deviceOptions) {
            this.amountMoney = amountMoney;
            this.deviceOptions = deviceOptions;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder deviceOptions(DeviceCheckoutOptions deviceOptions) {
            this.deviceOptions = deviceOptions;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder paymentOptions(PaymentOptions paymentOptions) {
            this.paymentOptions = paymentOptions;
            return this;
        }

        public Builder deadlineDuration(String deadlineDuration) {
            this.deadlineDuration = deadlineDuration;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder cancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        public Builder paymentIds(List<String> paymentIds) {
            this.paymentIds = paymentIds;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder paymentType(String paymentType) {
            this.paymentType = paymentType;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder appFeeMoney(Money appFeeMoney) {
            this.appFeeMoney = appFeeMoney;
            return this;
        }

        public TerminalCheckout build() {
            return new TerminalCheckout(this.amountMoney, this.deviceOptions, this.id, this.referenceId, this.note, this.orderId, this.paymentOptions, this.deadlineDuration, this.status, this.cancelReason, this.paymentIds, this.createdAt, this.updatedAt, this.appId, this.locationId, this.paymentType, this.customerId, this.appFeeMoney);
        }
    }
}

