/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class TerminalRefund {
    private final String id;
    private final String refundId;
    private final String paymentId;
    private final String orderId;
    private final Money amountMoney;
    private final String reason;
    private final String deviceId;
    private final String deadlineDuration;
    private final String status;
    private final String cancelReason;
    private final String createdAt;
    private final String updatedAt;
    private final String appId;
    private final String locationId;

    @JsonCreator
    public TerminalRefund(@JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="reason") String reason, @JsonProperty(value="device_id") String deviceId, @JsonProperty(value="id") String id, @JsonProperty(value="refund_id") String refundId, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="deadline_duration") String deadlineDuration, @JsonProperty(value="status") String status, @JsonProperty(value="cancel_reason") String cancelReason, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="app_id") String appId, @JsonProperty(value="location_id") String locationId) {
        this.id = id;
        this.refundId = refundId;
        this.paymentId = paymentId;
        this.orderId = orderId;
        this.amountMoney = amountMoney;
        this.reason = reason;
        this.deviceId = deviceId;
        this.deadlineDuration = deadlineDuration;
        this.status = status;
        this.cancelReason = cancelReason;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.appId = appId;
        this.locationId = locationId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="refund_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRefundId() {
        return this.refundId;
    }

    @JsonGetter(value="payment_id")
    public String getPaymentId() {
        return this.paymentId;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonGetter(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonGetter(value="deadline_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDeadlineDuration() {
        return this.deadlineDuration;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="cancel_reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCancelReason() {
        return this.cancelReason;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="app_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAppId() {
        return this.appId;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.refundId, this.paymentId, this.orderId, this.amountMoney, this.reason, this.deviceId, this.deadlineDuration, this.status, this.cancelReason, this.createdAt, this.updatedAt, this.appId, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TerminalRefund)) {
            return false;
        }
        TerminalRefund other = (TerminalRefund)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.refundId, other.refundId) && Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.reason, other.reason) && Objects.equals(this.deviceId, other.deviceId) && Objects.equals(this.deadlineDuration, other.deadlineDuration) && Objects.equals(this.status, other.status) && Objects.equals(this.cancelReason, other.cancelReason) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.appId, other.appId) && Objects.equals(this.locationId, other.locationId);
    }

    public String toString() {
        return "TerminalRefund [paymentId=" + this.paymentId + ", amountMoney=" + this.amountMoney + ", reason=" + this.reason + ", deviceId=" + this.deviceId + ", id=" + this.id + ", refundId=" + this.refundId + ", orderId=" + this.orderId + ", deadlineDuration=" + this.deadlineDuration + ", status=" + this.status + ", cancelReason=" + this.cancelReason + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", appId=" + this.appId + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.paymentId, this.amountMoney, this.reason, this.deviceId).id(this.getId()).refundId(this.getRefundId()).orderId(this.getOrderId()).deadlineDuration(this.getDeadlineDuration()).status(this.getStatus()).cancelReason(this.getCancelReason()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).appId(this.getAppId()).locationId(this.getLocationId());
        return builder;
    }

    public static class Builder {
        private String paymentId;
        private Money amountMoney;
        private String reason;
        private String deviceId;
        private String id;
        private String refundId;
        private String orderId;
        private String deadlineDuration;
        private String status;
        private String cancelReason;
        private String createdAt;
        private String updatedAt;
        private String appId;
        private String locationId;

        public Builder(String paymentId, Money amountMoney, String reason, String deviceId) {
            this.paymentId = paymentId;
            this.amountMoney = amountMoney;
            this.reason = reason;
            this.deviceId = deviceId;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder refundId(String refundId) {
            this.refundId = refundId;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder deadlineDuration(String deadlineDuration) {
            this.deadlineDuration = deadlineDuration;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder cancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public TerminalRefund build() {
            return new TerminalRefund(this.paymentId, this.amountMoney, this.reason, this.deviceId, this.id, this.refundId, this.orderId, this.deadlineDuration, this.status, this.cancelReason, this.createdAt, this.updatedAt, this.appId, this.locationId);
        }
    }
}

