/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.TimeRange;
import java.util.Objects;

public class TerminalRefundQueryFilter {
    private final String deviceId;
    private final TimeRange createdAt;
    private final String status;

    @JsonCreator
    public TerminalRefundQueryFilter(@JsonProperty(value="device_id") String deviceId, @JsonProperty(value="created_at") TimeRange createdAt, @JsonProperty(value="status") String status) {
        this.deviceId = deviceId;
        this.createdAt = createdAt;
        this.status = status;
    }

    @JsonGetter(value="device_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TimeRange getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.createdAt, this.status);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TerminalRefundQueryFilter)) {
            return false;
        }
        TerminalRefundQueryFilter other = (TerminalRefundQueryFilter)obj;
        return Objects.equals(this.deviceId, other.deviceId) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.status, other.status);
    }

    public String toString() {
        return "TerminalRefundQueryFilter [deviceId=" + this.deviceId + ", createdAt=" + this.createdAt + ", status=" + this.status + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().deviceId(this.getDeviceId()).createdAt(this.getCreatedAt()).status(this.getStatus());
        return builder;
    }

    public static class Builder {
        private String deviceId;
        private TimeRange createdAt;
        private String status;

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder createdAt(TimeRange createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public TerminalRefundQueryFilter build() {
            return new TerminalRefundQueryFilter(this.deviceId, this.createdAt, this.status);
        }
    }
}

