/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class TimeRange {
    private final String startAt;
    private final String endAt;

    @JsonCreator
    public TimeRange(@JsonProperty(value="start_at") String startAt, @JsonProperty(value="end_at") String endAt) {
        this.startAt = startAt;
        this.endAt = endAt;
    }

    @JsonGetter(value="start_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStartAt() {
        return this.startAt;
    }

    @JsonGetter(value="end_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEndAt() {
        return this.endAt;
    }

    public int hashCode() {
        return Objects.hash(this.startAt, this.endAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TimeRange)) {
            return false;
        }
        TimeRange other = (TimeRange)obj;
        return Objects.equals(this.startAt, other.startAt) && Objects.equals(this.endAt, other.endAt);
    }

    public String toString() {
        return "TimeRange [startAt=" + this.startAt + ", endAt=" + this.endAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().startAt(this.getStartAt()).endAt(this.getEndAt());
        return builder;
    }

    public static class Builder {
        private String startAt;
        private String endAt;

        public Builder startAt(String startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder endAt(String endAt) {
            this.endAt = endAt;
            return this;
        }

        public TimeRange build() {
            return new TimeRange(this.startAt, this.endAt);
        }
    }
}

