/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class TipSettings {
    private final Boolean allowTipping;
    private final Boolean separateTipScreen;
    private final Boolean customTipField;
    private final List<Integer> tipPercentages;
    private final Boolean smartTipping;

    @JsonCreator
    public TipSettings(@JsonProperty(value="allow_tipping") Boolean allowTipping, @JsonProperty(value="separate_tip_screen") Boolean separateTipScreen, @JsonProperty(value="custom_tip_field") Boolean customTipField, @JsonProperty(value="tip_percentages") List<Integer> tipPercentages, @JsonProperty(value="smart_tipping") Boolean smartTipping) {
        this.allowTipping = allowTipping;
        this.separateTipScreen = separateTipScreen;
        this.customTipField = customTipField;
        this.tipPercentages = tipPercentages;
        this.smartTipping = smartTipping;
    }

    @JsonGetter(value="allow_tipping")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAllowTipping() {
        return this.allowTipping;
    }

    @JsonGetter(value="separate_tip_screen")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getSeparateTipScreen() {
        return this.separateTipScreen;
    }

    @JsonGetter(value="custom_tip_field")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getCustomTipField() {
        return this.customTipField;
    }

    @JsonGetter(value="tip_percentages")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Integer> getTipPercentages() {
        return this.tipPercentages;
    }

    @JsonGetter(value="smart_tipping")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getSmartTipping() {
        return this.smartTipping;
    }

    public int hashCode() {
        return Objects.hash(this.allowTipping, this.separateTipScreen, this.customTipField, this.tipPercentages, this.smartTipping);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TipSettings)) {
            return false;
        }
        TipSettings other = (TipSettings)obj;
        return Objects.equals(this.allowTipping, other.allowTipping) && Objects.equals(this.separateTipScreen, other.separateTipScreen) && Objects.equals(this.customTipField, other.customTipField) && Objects.equals(this.tipPercentages, other.tipPercentages) && Objects.equals(this.smartTipping, other.smartTipping);
    }

    public String toString() {
        return "TipSettings [allowTipping=" + this.allowTipping + ", separateTipScreen=" + this.separateTipScreen + ", customTipField=" + this.customTipField + ", tipPercentages=" + this.tipPercentages + ", smartTipping=" + this.smartTipping + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().allowTipping(this.getAllowTipping()).separateTipScreen(this.getSeparateTipScreen()).customTipField(this.getCustomTipField()).tipPercentages(this.getTipPercentages()).smartTipping(this.getSmartTipping());
        return builder;
    }

    public static class Builder {
        private Boolean allowTipping;
        private Boolean separateTipScreen;
        private Boolean customTipField;
        private List<Integer> tipPercentages;
        private Boolean smartTipping;

        public Builder allowTipping(Boolean allowTipping) {
            this.allowTipping = allowTipping;
            return this;
        }

        public Builder separateTipScreen(Boolean separateTipScreen) {
            this.separateTipScreen = separateTipScreen;
            return this;
        }

        public Builder customTipField(Boolean customTipField) {
            this.customTipField = customTipField;
            return this;
        }

        public Builder tipPercentages(List<Integer> tipPercentages) {
            this.tipPercentages = tipPercentages;
            return this;
        }

        public Builder smartTipping(Boolean smartTipping) {
            this.smartTipping = smartTipping;
            return this;
        }

        public TipSettings build() {
            return new TipSettings(this.allowTipping, this.separateTipScreen, this.customTipField, this.tipPercentages, this.smartTipping);
        }
    }
}

