/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Address;
import com.squareup.square.models.Refund;
import com.squareup.square.models.Tender;
import java.util.List;
import java.util.Objects;

public class Transaction {
    private final String id;
    private final String locationId;
    private final String createdAt;
    private final List<Tender> tenders;
    private final List<Refund> refunds;
    private final String referenceId;
    private final String product;
    private final String clientId;
    private final Address shippingAddress;
    private final String orderId;

    @JsonCreator
    public Transaction(@JsonProperty(value="id") String id, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="tenders") List<Tender> tenders, @JsonProperty(value="refunds") List<Refund> refunds, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="product") String product, @JsonProperty(value="client_id") String clientId, @JsonProperty(value="shipping_address") Address shippingAddress, @JsonProperty(value="order_id") String orderId) {
        this.id = id;
        this.locationId = locationId;
        this.createdAt = createdAt;
        this.tenders = tenders;
        this.refunds = refunds;
        this.referenceId = referenceId;
        this.product = product;
        this.clientId = clientId;
        this.shippingAddress = shippingAddress;
        this.orderId = orderId;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="tenders")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Tender> getTenders() {
        return this.tenders;
    }

    @JsonGetter(value="refunds")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Refund> getRefunds() {
        return this.refunds;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonGetter(value="product")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getProduct() {
        return this.product;
    }

    @JsonGetter(value="client_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientId() {
        return this.clientId;
    }

    @JsonGetter(value="shipping_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.createdAt, this.tenders, this.refunds, this.referenceId, this.product, this.clientId, this.shippingAddress, this.orderId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.tenders, other.tenders) && Objects.equals(this.refunds, other.refunds) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.product, other.product) && Objects.equals(this.clientId, other.clientId) && Objects.equals(this.shippingAddress, other.shippingAddress) && Objects.equals(this.orderId, other.orderId);
    }

    public String toString() {
        return "Transaction [id=" + this.id + ", locationId=" + this.locationId + ", createdAt=" + this.createdAt + ", tenders=" + this.tenders + ", refunds=" + this.refunds + ", referenceId=" + this.referenceId + ", product=" + this.product + ", clientId=" + this.clientId + ", shippingAddress=" + this.shippingAddress + ", orderId=" + this.orderId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).locationId(this.getLocationId()).createdAt(this.getCreatedAt()).tenders(this.getTenders()).refunds(this.getRefunds()).referenceId(this.getReferenceId()).product(this.getProduct()).clientId(this.getClientId()).shippingAddress(this.getShippingAddress()).orderId(this.getOrderId());
        return builder;
    }

    public static class Builder {
        private String id;
        private String locationId;
        private String createdAt;
        private List<Tender> tenders;
        private List<Refund> refunds;
        private String referenceId;
        private String product;
        private String clientId;
        private Address shippingAddress;
        private String orderId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder tenders(List<Tender> tenders) {
            this.tenders = tenders;
            return this;
        }

        public Builder refunds(List<Refund> refunds) {
            this.refunds = refunds;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public Builder product(String product) {
            this.product = product;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Transaction build() {
            return new Transaction(this.id, this.locationId, this.createdAt, this.tenders, this.refunds, this.referenceId, this.product, this.clientId, this.shippingAddress, this.orderId);
        }
    }
}

