/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Booking;
import java.util.Objects;

public class UpdateBookingRequest {
    private final String idempotencyKey;
    private final Booking booking;

    @JsonCreator
    public UpdateBookingRequest(@JsonProperty(value="booking") Booking booking, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        this.booking = booking;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="booking")
    public Booking getBooking() {
        return this.booking;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.booking);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateBookingRequest)) {
            return false;
        }
        UpdateBookingRequest other = (UpdateBookingRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.booking, other.booking);
    }

    public String toString() {
        return "UpdateBookingRequest [booking=" + this.booking + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.booking).idempotencyKey(this.getIdempotencyKey());
        return builder;
    }

    public static class Builder {
        private Booking booking;
        private String idempotencyKey;

        public Builder(Booking booking) {
            this.booking = booking;
        }

        public Builder booking(Booking booking) {
            this.booking = booking;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public UpdateBookingRequest build() {
            return new UpdateBookingRequest(this.booking, this.idempotencyKey);
        }
    }
}

