/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CustomerGroup;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class UpdateCustomerGroupResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final CustomerGroup group;

    @JsonCreator
    public UpdateCustomerGroupResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="group") CustomerGroup group) {
        this.errors = errors;
        this.group = group;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="group")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CustomerGroup getGroup() {
        return this.group;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.group);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateCustomerGroupResponse)) {
            return false;
        }
        UpdateCustomerGroupResponse other = (UpdateCustomerGroupResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.group, other.group);
    }

    public String toString() {
        return "UpdateCustomerGroupResponse [errors=" + this.errors + ", group=" + this.group + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).group(this.getGroup());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private CustomerGroup group;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder group(CustomerGroup group) {
            this.group = group;
            return this;
        }

        public UpdateCustomerGroupResponse build() {
            UpdateCustomerGroupResponse model = new UpdateCustomerGroupResponse(this.errors, this.group);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

