/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Invoice;
import java.util.List;
import java.util.Objects;

public class UpdateInvoiceRequest {
    private final Invoice invoice;
    private final String idempotencyKey;
    private final List<String> fieldsToClear;

    @JsonCreator
    public UpdateInvoiceRequest(@JsonProperty(value="invoice") Invoice invoice, @JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="fields_to_clear") List<String> fieldsToClear) {
        this.invoice = invoice;
        this.idempotencyKey = idempotencyKey;
        this.fieldsToClear = fieldsToClear;
    }

    @JsonGetter(value="invoice")
    public Invoice getInvoice() {
        return this.invoice;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="fields_to_clear")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getFieldsToClear() {
        return this.fieldsToClear;
    }

    public int hashCode() {
        return Objects.hash(this.invoice, this.idempotencyKey, this.fieldsToClear);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateInvoiceRequest)) {
            return false;
        }
        UpdateInvoiceRequest other = (UpdateInvoiceRequest)obj;
        return Objects.equals(this.invoice, other.invoice) && Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.fieldsToClear, other.fieldsToClear);
    }

    public String toString() {
        return "UpdateInvoiceRequest [invoice=" + this.invoice + ", idempotencyKey=" + this.idempotencyKey + ", fieldsToClear=" + this.fieldsToClear + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.invoice).idempotencyKey(this.getIdempotencyKey()).fieldsToClear(this.getFieldsToClear());
        return builder;
    }

    public static class Builder {
        private Invoice invoice;
        private String idempotencyKey;
        private List<String> fieldsToClear;

        public Builder(Invoice invoice) {
            this.invoice = invoice;
        }

        public Builder invoice(Invoice invoice) {
            this.invoice = invoice;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder fieldsToClear(List<String> fieldsToClear) {
            this.fieldsToClear = fieldsToClear;
            return this;
        }

        public UpdateInvoiceRequest build() {
            return new UpdateInvoiceRequest(this.invoice, this.idempotencyKey, this.fieldsToClear);
        }
    }
}

